<?php 
//Template Name: About
get_header('custom');
$query = get_queried_object();
$miss = get_post(60);
$vis = get_post(64);
$serv = get_post(66);
$accordion = get_posts([
    'post_status'   => 'publish',
    'order'         => 'ASC',
    'tax_query' => array([
        'taxonomy'  => 'category',
        'field'     => 'slug',
        'terms'     => 'accordion'
    ])
]);
$yus = get_post(21);
$yus_posts = get_posts([
    'post_status'   => 'publish',
    'order'         => 'ASC',
    'include'       => array(24,30,32,34)
]);
$mid = get_post(75);
$testi = get_posts([
    'post_status'   => 'publish',
    'tax_query' => array([
        'taxonomy'  => 'category',
        'field'     => 'slug',
        'terms'     => 'testimonial'
    ])   
]);
?>

    <div class="hero-img">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h1><?php echo $query->post_title;?></h1>
                </div>
            </div>
        </div>
    </div>

    <div class="abt-page">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <img src="<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($query->ID),'full')[0];?>" class="img-responsive" alt="">
                </div>
                <div class="col-lg-6">
                    <?php echo wpautop($query->post_content);?>
                </div>
                <div class="col-lg-6">
                    <div class="wrapper">
                        <div class="icon">
                            <img src="<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($miss->ID),'full')[0];?>" class="img-responsive" alt="">
                        </div>
                        <h3><?php echo $miss->post_title;?></h3>
                        <?php echo wpautop($miss->post_content);?>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="wrapper">
                        <div class="icon">
                            <img src="<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($vis->ID),'full')[0];?>" class="img-responsive" alt="">
                        </div>
                        <h3><?php echo $vis->post_title;?></h3>
                        <?php echo wpautop($vis->post_content);?>                    
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="abt-sec-two" style="background-image:url(<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($serv->ID),'full')[0];?>)">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="content">
                        <h1><?php echo $serv->post_title;?></h1>
                        <?php echo wpautop($serv->post_content);?>
                        <div class="panel-group" id="accordion">
                            <?php 
                            foreach($accordion as $key => $posts){
                            ?>
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                <h4 class="panel-title">
                                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#<?php echo $posts->ID;?>">
                                    <?php echo $posts->post_title;?>
                                    </a>
                                </h4>
                                </div>
                                <div id="<?php echo $posts->ID;?>" class="panel-collapse collapse <?php echo ($key == 0) ? 'in':''; ?>">
                                <div class="panel-body">
                                    <?php echo wpautop($posts->post_content);?>
                                </div>
                                </div>
                            </div>
                            <?php } ?>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="yus">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <h4><?php echo $yus->post_title;?></h4>
                    <h1><?php echo $yus->post_excerpt;?></h1>
                    
                </div>
                <div class="col-lg-6">
                    <p class="intro"><?php echo $yus->post_content;?></p>
                </div>    
                <div class="col-lg-12">
                    <ul class="list-unstyled wrapper">
                        <?php 
                        foreach($yus_posts as $posts){
                            $image = get_field('icon',$posts->ID);
                        ?>
                        <li>
                            <div class="icon">
                                <img src="<?php echo $image;?>" class="img-responsive" alt="">
                            </div>
                            <h3><?php echo $posts->post_title;?></h3>
                            <?php echo wpautop($posts->post_content);?>
                        </li>
                        <?php } ?>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="midbanner" style="background-image:url(<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($mid->ID),'full')[0]; ?>)">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="content">
                        <h1><?php echo $mid->post_title;?></h1>
                        <?php echo wpautop($mid->post_content);?>
                        <a href="">Discover More</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="testi">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <h4>Testimonials</h4>
                    <h1>Success Stories</h1>
                    <p>Don't just take our word for it - hear from our satisfied learners who have achieved success with Stratos Global</p>
                </div>
                <div class="col-lg-8">
                    <ul>
                        <?php 
                        foreach($testi as $posts){
                            $image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
                        
                        ?>
                        <li>
                            <?php if(!empty($image)){ ?>
                                <img src="<?php echo $image[0];?>" class="img-responsive" alt="">
                            <?php } else{ ?>
                                <div class="name-label">
                                    <h3><?php echo $posts->post_title[0];?></h3>
                                </div>
                            <?php } ?> 
                            <div class="title">
                                <h4><?php echo $posts->post_title;?></h4>
                                <div class="stars">
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                </div>
                            </div>
                            <?php echo wpautop($posts->post_content);?>
                        </li>
                        <?php } ?>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <?php get_footer('custom');?>