<?php 
//Template Name: Home
get_header('custom');
$banner = get_post(19);
$yus = get_post(21);
$yus_posts = get_posts([
    'post_status'   => 'publish',
    'order'         => 'ASC',
    'include'       => array(24,30,32,34)
]);

$serv_info = get_post(36);
$serv = get_posts([
    'post_status'   => 'publish',
    'order'         => "ASC",
    'exclude'       => array(106),
    'tax_query' => array([
        'taxonomy'  => 'category',
        'field'     => 'slug',
        'terms'     => 'services'
    ])   
]);
$ticker = get_post(40);
$abt = get_post(42);
$testi = get_posts([
    'post_status'   => 'publish',
    'tax_query' => array([
        'taxonomy'  => 'category',
        'field'     => 'slug',
        'terms'     => 'testimonial'
    ])   
]);
?>

    <div class="banner" style="background-image:url(<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($banner->ID),'full')[0];?>)">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="content">
                        <?php echo wpautop($banner->post_content);?>
                        <a href="">Learn More</a>
                    </div> 
                </div>
            </div>
        </div>
    </div>

    <div class="progressbar">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Porro nisi praesentium ea mollitia commodi quam repellat soluta fugit facere dolorem reprehenderit ratione quaerat, molestias provident labore nihil debitis eos dignissimos.</p>
                    <ul class="list-inline">
                        <li>
                        <div class="progress-circle" style="--value: 75">
                            <span class="value">75%</span>
                        </div>
                        <h4>Online Skills</h4>
                        </li>
                        <li>
                        <div class="progress-circle" style="--value: 65">
                            <span class="value">65%</span>
                        </div>
                        <h4>Passive Income</h4>
                        </li>
                        <li>
                        <div class="progress-circle" style="--value: 80">
                            <span class="value">80%</span>
                        </div>
                        <h4>Work from home</h4>
                        </li>
                        <li>
                        <div class="progress-circle" style="--value: 60">
                            <span class="value">60%</span>
                        </div>
                        <h4>Digital Tools</h4>
                        </li>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="yus">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <h4><?php echo $yus->post_title;?></h4>
                    <h1><?php echo $yus->post_excerpt;?></h1>
                    
                </div>
                <div class="col-lg-6">
                    <p class="intro"><?php echo $yus->post_content;?></p>
                </div>    
                <div class="col-lg-12">
                    <ul class="list-unstyled wrapper">
                        <?php 
                        foreach($yus_posts as $posts){
                            $image = get_field('icon',$posts->ID);
                        ?>
                        <li>
                            <div class="icon">
                                <img src="<?php echo $image;?>" class="img-responsive" alt="">
                            </div>
                            <h3><?php echo $posts->post_title;?></h3>
                            <?php echo wpautop($posts->post_content);?>
                        </li>
                        <?php } ?>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="serv" style="background-image:url(<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($serv_info->ID),'full')[0];?>)">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <img src="" class="img-responsive" alt="">
                </div>
                <div class="col-lg-6">
                    <h4><?php echo $serv_info->post_title;?></h4>
                    <?php echo wpautop($serv_info->post_content);?>
                    <ul class="list-inline">
                        <?php 
                        foreach($serv as $posts){
                            $image = get_field('icon',$posts->ID);
                        
                        ?>
                        <li>
                            <div class="icon">
                                <img src="<?php echo $image;?>" class="img-responsive" alt="">
                            </div>
                                <div class="content">
                                    <h3><?php echo $posts->post_title;?></h3>
                                    <?php echo wpautop($posts->post_excerpt);?>
                                </div>
                        </li>
                        <?php } ?>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="ticker">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <?php echo $ticker->post_content;?>
                </div>
            </div>
        </div>
    </div>

    <div class="abt">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <img src="<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($abt->ID),'full')[0];?>" class="img-responsive" alt="">
                    <div class="tag">
                        <h3>14+</h3>
                        <span>Years of Experience</span>
                    </div>
                </div>
                <div class="col-lg-6">
                    <h4><?php echo $abt->post_title;?></h4>
                    <?php echo $abt->post_content;?>
                    <a href="<?php echo get_permalink(7);?>">learn more</a>
                </div>
            </div>
        </div>
    </div>

    <div class="subs">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h1>subscribe Stratos Global</h1>
                    <p>Stay up-to-date with our latest news and updates, including new training programs, promotions, and more</p>
                    <form action="">
                        <input type="text" placeholder="Enter your e-mail">
                        <button>subscribe now</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="testi">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <h4>Testimonials</h4>
                    <h1>Success Stories</h1>
                    <p>Don't just take our word for it - hear from our satisfied learners who have achieved success with Stratos Global</p>
                </div>
                <div class="col-lg-8">
                    <ul>
                        <?php 
                        foreach($testi as $posts){
                            $image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
                        
                        ?>
                        <li>
                            <?php if(!empty($image)){ ?>
                                <img src="<?php echo $image[0];?>" class="img-responsive" alt="">
                            <?php } else{ ?>
                                <div class="name-label">
                                    <h3><?php echo $posts->post_title[0];?></h3>
                                </div>
                            <?php } ?>    
                            <div class="title">
                                <h4><?php echo $posts->post_title;?></h4>
                                <div class="stars">
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                </div>
                            </div>
                            <?php echo wpautop($posts->post_content);?>
                        </li>
                        <?php } ?>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <?php get_footer('custom');?>