<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<?php wp_head(); ?>
</head>

<body>
    <div class="mainnav" data-spy="affix" data-offset-top="900">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-xs-7">
                    <div class="hamburger">
                        <i class="fa fa-navicon"></i>
                    </div>
                    <div class="logo">
                        <img src="<?php echo get_template_directory_uri().'/assets/images/final-logo.png';?>" class="img-responsive main-logo" alt="">
                        <img src="<?php echo get_template_directory_uri().'/assets/images/logo.png';?>" class="img-responsive affix-logo" alt="">
                    </div>
                </div>
                <div class="col-lg-5">
                    <?php
                        wp_nav_menu(array(
                            'menu' => 'main_menu',
                            'depth' => 1,
                            'menu_class' => 'list-inline',
                            'fallback_cb' => false,
                            'walker' => new WP_Bootstrap_Navwalker(),
                        ));
                    ?>
                </div>
                <div class="col-lg-4 col-xs-5">
                    <?php dynamic_sidebar('media');?>
                </div>
            </div>
        </div>
    </div>

    <div class="backface">
        <div class="sidenav">
            <?php
                        wp_nav_menu(array(
                            'menu' => 'main_menu',
                            'depth' => 1,
                            'menu_class' => 'list-unstyled',
                            'fallback_cb' => false,
                            'walker' => new WP_Bootstrap_Navwalker(),
                        ));
                    ?>
            <div class="close">
                <i class="fa fa-close"></i>
            </div>        
        </div>
    </div>
