<?php 
//Template Name: Services
get_header('custom');
$query = get_queried_object();
$serv = get_posts([
    'post_status'   => 'publish',
    'order'         => "ASC",
    'exclude'       => array(32),
    'tax_query' => array([
        'taxonomy'  => 'category',
        'field'     => 'slug',
        'terms'     => 'services'
    ])   
]);
?>

    <div class="hero-img" style="background-image:url(<?php echo wp_get_attachment_image_src(get_post_thumbnail_id($query->ID),'full')[0];?>)">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h1><?php echo $query->post_title;?></h1>
                </div>
            </div>
        </div>
    </div>

    <div class="serv-page">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h1 style="text-align: center;">Our Services</h1>
                    <p class="intro">At Stratos Global, we offer a comprehensive range of services designed to empower individuals to succeed in the digital world. Our offerings are tailored for both beginners and professionals, providing a clear and structured path to online success.</p>
                    <ul class="list-unstyled">
                        <?php 
                        foreach($serv as $posts){
                            $image = wp_get_attachment_image_src(get_post_thumbnail_id($posts->ID),'full');
                        
                        ?>
                        <li>
                            <img src="<?php echo $image[0];?>" class="img-responsive" alt="">
                            <div class="content">
                                <h3><?php echo $posts->post_title;?></h3>
                                <?php echo wpautop($posts->post_content);?>
                            </div>
                        </li>
                        <?php } ?>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <?php get_footer('custom');?>